<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Admin;

trait TraitAdminSetters
{
    use TraitAdminProperties;

    /**
     * @return static 
     */
    final public function setId(string $id)
    {
        $this -> id = $id;

        return $this;
    }

    /**
     * @return static 
     */
    public function setUsername(string $username)
    {
        $this -> username = $username;

        return $this;
    }

    /**
     * @return static 
     */
    public function setPassword(string $password)
    {
        $this -> password = $password;

        return $this;
    }

    /**
     * @return static 
     */
    public function setMetaAccess(string $metaAccess)
    {
        $this -> metaAccess = $metaAccess;

        return $this;
    }

    /**
     * @return static 
     */
    public function setMetaLastActive(string $metaLastActive)
    {
        $this -> metaLastActive = $metaLastActive;

        return $this;
    }

    /**
     * @return static 
     */
    public function setStampRegistration(string $stampRegistration)
    {
        $this -> stampRegistration = $stampRegistration;

        return $this;
    }

    /**
     * @return static 
     */
    public function setStampLastUpdate(string $stampLastUpdate)
    {
        $this -> stampLastUpdate = $stampLastUpdate;

        return $this;
    }
}
